/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.dal.redis;

import jakarta.annotation.Resource;
import java.time.Duration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Repository;
import xyz.migoo.framework.infra.dal.redis.RedisKeyConstants;

@Repository
public class CaptchaRedis {
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    private static String formatKey(String uuid) {
        return String.format(RedisKeyConstants.CAPTCHA_CODE.getKeyTemplate(), uuid);
    }

    public String get(String uuid) {
        String redisKey = CaptchaRedis.formatKey(uuid);
        return (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
    }

    public void set(String uuid, String code, Duration timeout) {
        String redisKey = CaptchaRedis.formatKey(uuid);
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)code, timeout);
    }

    public void delete(String uuid) {
        String redisKey = CaptchaRedis.formatKey(uuid);
        this.stringRedisTemplate.delete((Object)redisKey);
    }
}

