/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.dal.redis;

import jakarta.annotation.Resource;
import java.time.Duration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Repository;
import xyz.migoo.framework.common.util.json.JsonUtils;
import xyz.migoo.framework.infra.dal.redis.RedisKeyConstants;
import xyz.migoo.framework.security.config.SecurityProperties;
import xyz.migoo.framework.security.core.LoginUser;

@Repository
public class LoginUserRedis {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private SecurityProperties securityProperties;

    private static String formatKey(String sessionId) {
        return String.format(RedisKeyConstants.LOGIN_USER.getKeyTemplate(), sessionId);
    }

    public LoginUser get(String sessionId) {
        String redisKey = LoginUserRedis.formatKey(sessionId);
        return (LoginUser)JsonUtils.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)redisKey)), (Class)RedisKeyConstants.LOGIN_USER.getValueType());
    }

    public void set(String sessionId, LoginUser loginUser) {
        String redisKey = LoginUserRedis.formatKey(sessionId);
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JsonUtils.toJsonString((Object)loginUser), Duration.ofMillis(this.securityProperties.getToken().getTimeout().toMillis()));
    }

    public void remove(String sessionId) {
        String redisKey = LoginUserRedis.formatKey(sessionId);
        this.stringRedisTemplate.delete((Object)redisKey);
    }
}

