/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.login;

import cn.hutool.core.util.IdUtil;
import jakarta.annotation.Resource;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import xyz.migoo.framework.security.config.SecurityProperties;
import xyz.migoo.framework.security.core.LoginUser;
import xyz.migoo.framework.security.core.service.LoginUserCacheService;
import xyz.migoo.framework.security.core.service.SecuritySessionAuthService;

@Service
public class SecuritySessionAuthServiceImpl
implements SecuritySessionAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecuritySessionAuthServiceImpl.class);
    @Resource
    private LoginUserCacheService loginUserCacheService;
    @Resource
    private SecurityProperties securityProperties;

    private static String generateSessionId() {
        return IdUtil.fastSimpleUUID();
    }

    public String createUserSession(LoginUser loginUser, String ... params) {
        String sessionId = SecuritySessionAuthServiceImpl.generateSessionId();
        loginUser.setUpdateTime(new Date());
        this.loginUserCacheService.set(sessionId, loginUser);
        return sessionId;
    }

    public void refreshUserSession(String sessionId, LoginUser loginUser) {
        loginUser.setUpdateTime(new Date());
        this.loginUserCacheService.set(sessionId, loginUser);
    }

    public void deleteUserSession(String sessionId) {
        this.loginUserCacheService.delete(sessionId);
    }

    public LoginUser getLoginUser(String sessionId) {
        return this.loginUserCacheService.get(sessionId);
    }

    public Long getSessionTimeoutMillis() {
        return this.securityProperties.getToken().getTimeout().toMillis();
    }
}

