/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.login;

import cn.hutool.crypto.SecureUtil;
import jakarta.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.enums.NumberConstants;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.common.util.json.JsonUtils;
import xyz.migoo.framework.infra.controller.login.vo.AuthLoginReqVO;
import xyz.migoo.framework.infra.controller.login.vo.AuthLoginRespVO;
import xyz.migoo.framework.infra.dal.dataobject.sys.User;
import xyz.migoo.framework.infra.enums.SysErrorCodeConstants;
import xyz.migoo.framework.infra.service.login.TokenService;
import xyz.migoo.framework.infra.service.sys.user.UserService;
import xyz.migoo.framework.security.config.SecurityProperties;
import xyz.migoo.framework.security.core.LoginUser;
import xyz.migoo.framework.security.core.service.SecuritySessionAuthService;

@Service
public class TokenServiceImpl
implements TokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenServiceImpl.class);
    @Resource
    @Lazy
    private AuthenticationManager authenticationManager;
    @Resource
    private SecuritySessionAuthService securitySessionAuthService;
    @Resource
    private UserService userService;
    @Resource
    private SecurityProperties securityProperties;

    public UserDetails loadUserByUsername(String jsonUser) {
        AuthLoginReqVO req = (AuthLoginReqVO)JsonUtils.parseObject((String)jsonUser, AuthLoginReqVO.class);
        return this.userService.toLoginUser(this.userService.get(req.getUsername()));
    }

    public LoginUser verifyTokenAndRefresh(String token) {
        LoginUser loginUser = this.securitySessionAuthService.getLoginUser(token);
        if (Objects.nonNull(loginUser)) {
            this.refreshLoginUserCache(token, loginUser);
        }
        return loginUser;
    }

    public void signOut(String token) {
        this.securitySessionAuthService.deleteUserSession(token);
    }

    @Override
    public AuthLoginRespVO signIn(AuthLoginReqVO req) {
        LoginUser loginUser = this.login0(JsonUtils.toJsonString((Object)req), req.getPassword());
        String token = this.securitySessionAuthService.createUserSession(loginUser, new String[0]);
        return new AuthLoginRespVO().setToken(token).setRequiredBindAuthenticator(loginUser.isRequiredBindAuthenticator());
    }

    private LoginUser login0(String reqJson, String password) {
        try {
            password = SecureUtil.aes((byte[])this.securityProperties.getPasswordSecret().getBytes(StandardCharsets.UTF_8)).decryptStr(password);
            Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)reqJson, (Object)password));
            return (LoginUser)authentication.getPrincipal();
        }
        catch (BadCredentialsException badCredentialsException) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.AUTH_LOGIN_BAD_CREDENTIALS);
        }
        catch (DisabledException disabledException) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.AUTH_LOGIN_USER_DISABLED);
        }
        catch (AuthenticationException authenticationException) {
            log.error("[login0][user({}) \u53d1\u751f\u672a\u77e5\u5f02\u5e38]", (Object)reqJson, (Object)authenticationException);
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.AUTH_LOGIN_FAIL_UNKNOWN);
        }
    }

    private void refreshLoginUserCache(String token, LoginUser loginUser) {
        if (System.currentTimeMillis() - loginUser.getUpdateTime().getTime() > this.securitySessionAuthService.getSessionTimeoutMillis() / (long)NumberConstants.N_2.intValue()) {
            User user = this.userService.get(loginUser.getUsername());
            if (Objects.isNull((Object)user) || !CommonStatus.isEnabled((int)user.getStatus())) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.AUTH_TOKEN_EXPIRED);
            }
            this.securitySessionAuthService.refreshUserSession(token, loginUser);
        }
    }
}

