/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.sys.dept;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.infra.controller.sys.dept.vo.DeptQueryReqVO;
import xyz.migoo.framework.infra.dal.dataobject.sys.Dept;
import xyz.migoo.framework.infra.dal.mapper.sys.DeptMapper;
import xyz.migoo.framework.infra.enums.DeptIdEnum;
import xyz.migoo.framework.infra.enums.SysErrorCodeConstants;
import xyz.migoo.framework.infra.service.sys.dept.DeptService;
import xyz.migoo.framework.mybatis.core.dataobject.BaseDO;

@Service
public class DeptServiceImpl
implements DeptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeptServiceImpl.class);
    private static final long SCHEDULER_PERIOD = 300000L;
    private volatile Map<Long, Dept> deptCache;
    private volatile Multimap<Long, Dept> parentDeptCache;
    private volatile LocalDateTime maxUpdateTime;
    @Resource
    private DeptMapper deptMapper;

    @Override
    @PostConstruct
    public synchronized void initLocalCache() {
        List<Dept> deptList = this.loadDeptIfUpdate(this.maxUpdateTime);
        if (CollUtil.isEmpty(deptList)) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMultimap.Builder parentBuilder = ImmutableMultimap.builder();
        deptList.forEach(dept -> {
            builder.put((Object)((Long)dept.getId()), (Object)dept);
            parentBuilder.put((Object)dept.getParentId(), (Object)dept);
        });
        this.deptCache = builder.build();
        this.parentDeptCache = parentBuilder.build();
        assert (!deptList.isEmpty());
        this.maxUpdateTime = deptList.stream().max(Comparator.comparing(BaseDO::getUpdateTime)).get().getUpdateTime();
        log.info("[initLocalCache][\u521d\u59cb\u5316 Dept \u6570\u91cf\u4e3a {}]", (Object)deptList.size());
    }

    @Scheduled(fixedDelay=300000L, initialDelay=300000L)
    public void schedulePeriodicRefresh() {
        this.initLocalCache();
    }

    private List<Dept> loadDeptIfUpdate(LocalDateTime maxUpdateTime) {
        if (maxUpdateTime == null) {
            log.info("[loadMenuIfUpdate][\u9996\u6b21\u52a0\u8f7d\u5168\u91cf\u90e8\u95e8]");
        } else {
            if (!this.deptMapper.selectExistsByUpdateTimeAfter(maxUpdateTime)) {
                return null;
            }
            log.info("[loadMenuIfUpdate][\u589e\u91cf\u52a0\u8f7d\u5168\u91cf\u90e8\u95e8]");
        }
        return this.deptMapper.selectList();
    }

    @Override
    public List<Dept> getList(Collection<Long> ids) {
        return this.deptMapper.selectBatchIds(ids);
    }

    @Override
    public List<Dept> getList(DeptQueryReqVO req) {
        return this.deptMapper.selectList(req);
    }

    @Override
    public void add(Dept dept) {
        this.deptMapper.insert((Object)dept);
    }

    @Override
    public void update(Dept dept) {
        this.deptMapper.updateById((Object)dept);
    }

    @Override
    public void verify(Long id, Long parentId, String name) {
        this.checkDeptExists(id);
        this.checkParentDeptEnable(id, parentId);
        this.checkDeptNameUnique(id, parentId, name);
    }

    @Override
    public Dept get(Long id) {
        return (Dept)((Object)this.deptMapper.selectById(id));
    }

    @Override
    public void remove(Long id) {
        this.deptMapper.deleteById(id);
    }

    public List<Dept> getDeptsByParentIdFromCache(Long parentId, boolean recursive) {
        ArrayList<Dept> result = new ArrayList<Dept>();
        this.listDeptsByParentIdFromCache(result, parentId, recursive ? Integer.MAX_VALUE : 1, this.parentDeptCache);
        return result;
    }

    private void listDeptsByParentIdFromCache(List<Dept> result, Long parentId, int recursiveCount, Multimap<Long, Dept> parentDeptMap) {
        if (recursiveCount == 0) {
            return;
        }
        Collection depts = parentDeptMap.get((Object)parentId);
        if (CollUtil.isEmpty((Collection)depts)) {
            return;
        }
        result.addAll(depts);
        depts.forEach(dept -> this.listDeptsByParentIdFromCache(result, (Long)dept.getId(), recursiveCount - 1, parentDeptMap));
    }

    private void checkParentDeptEnable(Long id, Long parentId) {
        if (Objects.isNull(parentId) || DeptIdEnum.ROOT.getId().equals(parentId)) {
            return;
        }
        if (parentId.equals(id)) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.DEPT_PARENT_ERROR);
        }
        Dept dept = (Dept)((Object)this.deptMapper.selectById(parentId));
        if (Objects.isNull((Object)dept)) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.DEPT_PARENT_NOT_EXITS);
        }
        if (!CommonStatus.isEnabled((int)dept.getStatus())) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.DEPT_NOT_ENABLE);
        }
        List<Dept> children = this.getDeptsByParentIdFromCache(id, true);
        if (children.stream().anyMatch(dept1 -> ((Long)dept1.getId()).equals(parentId))) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.DEPT_PARENT_IS_CHILD);
        }
    }

    private void checkDeptExists(Long id) {
        if (Objects.nonNull(id) && Objects.isNull(this.deptMapper.selectById(id))) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.DEPT_NOT_FOUND);
        }
    }

    private void checkDeptNameUnique(Long id, Long parentId, String name) {
        Dept dept = this.deptMapper.selectByParentIdAndName(parentId, name);
        if (Objects.nonNull((Object)dept)) {
            if (Objects.isNull(id)) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.DEPT_NAME_DUPLICATE);
            }
            if (!((Long)dept.getId()).equals(id)) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.DEPT_NAME_DUPLICATE);
            }
        }
    }
}

