/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.sys.permission;

import cn.hutool.core.collection.CollUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.common.util.collection.CollectionUtils;
import xyz.migoo.framework.infra.controller.sys.permission.menu.vo.MenuQueryReqVO;
import xyz.migoo.framework.infra.dal.dataobject.sys.Menu;
import xyz.migoo.framework.infra.dal.mapper.sys.MenuMapper;
import xyz.migoo.framework.infra.enums.MenuIdEnum;
import xyz.migoo.framework.infra.enums.MenuTypeEnum;
import xyz.migoo.framework.infra.enums.SysErrorCodeConstants;
import xyz.migoo.framework.infra.service.sys.permission.MenuService;
import xyz.migoo.framework.infra.service.sys.permission.PermissionService;
import xyz.migoo.framework.mybatis.core.dataobject.BaseDO;

@Service
public class MenuServiceImpl
implements MenuService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MenuServiceImpl.class);
    private static final long SCHEDULER_PERIOD = 300000L;
    private volatile Map<Long, Menu> menuCache;
    private volatile Multimap<String, Menu> permissionMenuCache;
    private volatile LocalDateTime maxUpdateTime;
    @Resource
    private MenuMapper menuMapper;
    @Resource
    @Lazy
    private PermissionService permissionService;

    @Override
    @PostConstruct
    public synchronized void initLocalCache() {
        List<Menu> menuList = this.loadMenuIfUpdate(this.maxUpdateTime);
        if (CollUtil.isEmpty(menuList)) {
            return;
        }
        ImmutableMap.Builder menuCacheBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder permMenuCacheBuilder = ImmutableMultimap.builder();
        menuList.forEach(menuDO -> {
            menuCacheBuilder.put((Object)((Long)menuDO.getId()), (Object)menuDO);
            permMenuCacheBuilder.put((Object)menuDO.getPermission(), (Object)menuDO);
        });
        this.menuCache = menuCacheBuilder.build();
        this.permissionMenuCache = permMenuCacheBuilder.build();
        assert (!menuList.isEmpty());
        this.maxUpdateTime = menuList.stream().max(Comparator.comparing(BaseDO::getUpdateTime)).get().getUpdateTime();
        log.info("[initLocalCache][\u7f13\u5b58\u83dc\u5355\uff0c\u6570\u91cf\u4e3a:{}]", (Object)menuList.size());
    }

    @Scheduled(fixedDelay=300000L, initialDelay=300000L)
    public void schedulePeriodicRefresh() {
        this.initLocalCache();
    }

    private List<Menu> loadMenuIfUpdate(LocalDateTime maxUpdateTime) {
        if (maxUpdateTime == null) {
            log.info("[loadMenuIfUpdate][\u9996\u6b21\u52a0\u8f7d\u5168\u91cf\u83dc\u5355]");
        } else {
            if (!this.menuMapper.selectExistsByUpdateTimeAfter(maxUpdateTime)) {
                return null;
            }
            log.info("[loadMenuIfUpdate][\u589e\u91cf\u52a0\u8f7d\u5168\u91cf\u83dc\u5355]");
        }
        return this.menuMapper.selectList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(Long menuId) {
        if (this.menuMapper.selectCountByParentId(menuId) > 0L) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_EXISTS_CHILDREN);
        }
        if (this.menuMapper.selectById(menuId) == null) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_NOT_EXISTS);
        }
        this.menuMapper.deleteById(menuId);
        this.permissionService.processMenuDeleted(menuId);
    }

    @Override
    public List<Menu> get(MenuQueryReqVO reqVO) {
        return this.menuMapper.selectList(reqVO);
    }

    @Override
    public List<Menu> get() {
        return this.menuMapper.selectList();
    }

    @Override
    public List<Menu> listMenusFromCache(Collection<Integer> menuTypes, Collection<Integer> menusStatuses) {
        if (CollectionUtils.isAnyEmpty((Collection[])new Collection[]{menuTypes, menusStatuses})) {
            return Collections.emptyList();
        }
        return this.menuCache.values().stream().filter(menu -> menuTypes.contains(menu.getType()) && menusStatuses.contains(menu.getStatus())).collect(Collectors.toList());
    }

    @Override
    public List<Menu> listMenusFromCache(Collection<Long> menuIds, Collection<Integer> menuTypes, Collection<Integer> menusStatuses) {
        if (CollectionUtils.isAnyEmpty((Collection[])new Collection[]{menuIds, menuTypes, menusStatuses})) {
            return Collections.emptyList();
        }
        return this.menuCache.values().stream().filter(menu -> menuIds.contains(menu.getId()) && menuTypes.contains(menu.getType()) && menusStatuses.contains(menu.getStatus())).collect(Collectors.toList());
    }

    @Override
    public List<Menu> getMenuListByPermissionFromCache(String permission) {
        return Lists.newArrayList((Iterable)this.permissionMenuCache.get((Object)permission));
    }

    @Override
    public Menu get(Long id) {
        return (Menu)((Object)this.menuMapper.selectById(id));
    }

    @Override
    public void add(Menu menu) {
        this.checkParentResource(menu.getParentId(), null);
        this.checkResource(menu.getParentId(), menu.getName(), null);
        this.initMenuProperty(menu);
        this.menuMapper.insert((Object)menu);
    }

    @Override
    public void update(Menu menu) {
        if (this.menuMapper.selectById((Serializable)menu.getId()) == null) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_NOT_EXISTS);
        }
        this.checkParentResource(menu.getParentId(), (Long)menu.getId());
        this.checkResource(menu.getParentId(), menu.getName(), (Long)menu.getId());
        this.initMenuProperty(menu);
        this.menuMapper.updateById((Object)menu);
    }

    @VisibleForTesting
    public void checkParentResource(Long parentId, Long childId) {
        if (parentId == null || MenuIdEnum.ROOT.getId().equals(parentId)) {
            return;
        }
        if (parentId.equals(childId)) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_PARENT_ERROR);
        }
        Menu menu = (Menu)((Object)this.menuMapper.selectById(parentId));
        if (menu == null) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_PARENT_NOT_EXISTS);
        }
        if (!MenuTypeEnum.DIR.getType().equals(menu.getType()) && !MenuTypeEnum.MENU.getType().equals(menu.getType())) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_PARENT_NOT_DIR_OR_MENU);
        }
    }

    @VisibleForTesting
    public void checkResource(Long parentId, String name, Long id) {
        Menu menu = this.menuMapper.selectByParentIdAndName(parentId, name);
        if (menu == null) {
            return;
        }
        if (id == null) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_NAME_DUPLICATE);
        }
        if (!((Long)menu.getId()).equals(id)) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.MENU_NAME_DUPLICATE);
        }
    }

    private void initMenuProperty(Menu menu) {
        if (MenuTypeEnum.BUTTON.getType().equals(menu.getType())) {
            menu.setComponent("");
            menu.setIcon("");
            menu.setPath("");
        }
    }
}

