/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.sys.permission;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.util.collection.CollectionUtils;
import xyz.migoo.framework.common.util.collection.MapUtils;
import xyz.migoo.framework.common.util.collection.SetUtils;
import xyz.migoo.framework.infra.dal.dataobject.sys.Menu;
import xyz.migoo.framework.infra.dal.dataobject.sys.Role;
import xyz.migoo.framework.infra.dal.dataobject.sys.RoleMenu;
import xyz.migoo.framework.infra.dal.dataobject.sys.UserRole;
import xyz.migoo.framework.infra.dal.mapper.sys.RoleMenuMapper;
import xyz.migoo.framework.infra.dal.mapper.sys.UserRoleMapper;
import xyz.migoo.framework.infra.service.sys.permission.MenuService;
import xyz.migoo.framework.infra.service.sys.permission.PermissionService;
import xyz.migoo.framework.infra.service.sys.permission.RoleService;
import xyz.migoo.framework.mybatis.core.dataobject.BaseDO;
import xyz.migoo.framework.security.core.util.SecurityFrameworkUtils;

@Service(value="ss")
public class PermissionServiceImpl
implements PermissionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionServiceImpl.class);
    private static final long SCHEDULER_PERIOD = 300000L;
    private volatile Multimap<Long, Long> roleMenuCache;
    private volatile Multimap<Long, Long> menuRoleCache;
    private volatile LocalDateTime maxUpdateTime;
    @Resource
    private RoleMenuMapper roleMenuMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    @Lazy
    private RoleService roleService;
    @Resource
    @Lazy
    private MenuService menuService;

    @Override
    @PostConstruct
    public void initLocalCache() {
        LocalDateTime now = LocalDateTime.now();
        List<RoleMenu> roleMenuList = this.loadRoleMenuIfUpdate(this.maxUpdateTime);
        if (CollUtil.isEmpty(roleMenuList)) {
            return;
        }
        ImmutableMultimap.Builder roleMenuCacheBuilder = ImmutableMultimap.builder();
        ImmutableMultimap.Builder menuRoleCacheBuilder = ImmutableMultimap.builder();
        roleMenuList.forEach(roleMenuDO -> {
            roleMenuCacheBuilder.put((Object)roleMenuDO.getRoleId(), (Object)roleMenuDO.getMenuId());
            menuRoleCacheBuilder.put((Object)roleMenuDO.getMenuId(), (Object)roleMenuDO.getRoleId());
        });
        this.roleMenuCache = roleMenuCacheBuilder.build();
        this.menuRoleCache = menuRoleCacheBuilder.build();
        assert (!roleMenuList.isEmpty());
        this.maxUpdateTime = now;
        log.info("[initLocalCache][\u521d\u59cb\u5316\u89d2\u8272\u4e0e\u83dc\u5355\u7684\u5173\u8054\u6570\u91cf\u4e3a {}]", (Object)roleMenuList.size());
    }

    @Scheduled(fixedDelay=300000L, initialDelay=300000L)
    public void schedulePeriodicRefresh() {
        this.initLocalCache();
    }

    private List<RoleMenu> loadRoleMenuIfUpdate(LocalDateTime maxUpdateTime) {
        if (maxUpdateTime == null) {
            log.info("[loadRoleMenuIfUpdate][\u9996\u6b21\u52a0\u8f7d\u5168\u91cf\u89d2\u8272\u4e0e\u83dc\u5355\u7684\u5173\u8054]");
        } else {
            if (Objects.isNull(this.roleMenuMapper.selectExistsByUpdateTimeAfter(maxUpdateTime))) {
                return null;
            }
            log.info("[loadRoleMenuIfUpdate][\u589e\u91cf\u52a0\u8f7d\u5168\u91cf\u89d2\u8272\u4e0e\u83dc\u5355\u7684\u5173\u8054]");
        }
        return this.roleMenuMapper.selectList();
    }

    @Override
    public List<Menu> getRoleMenusFromCache(Collection<Long> roleIds, Collection<Integer> menuTypes, Collection<Integer> menusStatuses) {
        if (CollectionUtils.isAnyEmpty((Collection[])new Collection[]{roleIds, menusStatuses, menusStatuses})) {
            return Collections.emptyList();
        }
        if (this.roleService.hasAnyAdmin(this.roleService.getRolesFromCache(roleIds))) {
            return this.menuService.listMenusFromCache(menuTypes, menusStatuses);
        }
        List menuIds = MapUtils.getList(this.roleMenuCache, roleIds);
        return this.menuService.listMenusFromCache(menuIds, menuTypes, menusStatuses);
    }

    @Override
    public Set<Long> getUserRoleIds(Long userId, Collection<Integer> roleStatuses) {
        List<UserRole> userRoleList = this.userRoleMapper.selectListByUserId(userId);
        if (CollectionUtil.isNotEmpty(roleStatuses)) {
            userRoleList.removeIf(userRoleDO -> {
                Role role = this.roleService.getRoleFromCache(userRoleDO.getRoleId());
                return role == null || !roleStatuses.contains(role.getStatus());
            });
        }
        return CollectionUtils.convertSet(userRoleList, UserRole::getRoleId);
    }

    @Override
    public Set<Long> getRoleMenuIds(Long roleId) {
        Role role = this.roleService.get(roleId);
        if (this.roleService.hasAnyAdmin(Collections.singletonList(role))) {
            return CollectionUtils.convertSet(this.menuService.get(), BaseDO::getId);
        }
        return CollectionUtils.convertSet(this.roleMenuMapper.selectListByRoleId(roleId), RoleMenu::getMenuId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void assignRoleMenu(Long roleId, Set<Long> menuIds) {
        Set dbMenuIds = CollectionUtils.convertSet(this.roleMenuMapper.selectListByRoleId(roleId), RoleMenu::getMenuId);
        Collection createMenuIds = CollUtil.subtract(menuIds, (Collection)dbMenuIds);
        Collection deleteMenuIds = CollUtil.subtract((Collection)dbMenuIds, menuIds);
        if (!CollectionUtil.isEmpty((Collection)createMenuIds)) {
            this.roleMenuMapper.insertList(roleId, createMenuIds);
        }
        if (!CollectionUtil.isEmpty((Collection)deleteMenuIds)) {
            this.roleMenuMapper.deleteListByRoleIdAndMenuIds(roleId, deleteMenuIds);
        }
    }

    @Override
    public Set<Long> getUserRoleIs(Long userId) {
        return CollectionUtils.convertSet(this.userRoleMapper.selectListByUserId(userId), UserRole::getRoleId);
    }

    @Override
    public void assignUserRole(Long userId, Set<Long> roleIds) {
        Set dbRoleIds = CollectionUtils.convertSet(this.userRoleMapper.selectListByUserId(userId), UserRole::getRoleId);
        Collection createRoleIds = CollUtil.subtract(roleIds, (Collection)dbRoleIds);
        Collection deleteMenuIds = CollUtil.subtract((Collection)dbRoleIds, roleIds);
        if (!CollectionUtil.isEmpty((Collection)createRoleIds)) {
            this.userRoleMapper.insertList(userId, createRoleIds);
        }
        if (!CollectionUtil.isEmpty((Collection)deleteMenuIds)) {
            this.userRoleMapper.deleteListByUserIdAndRoleIdIds(userId, deleteMenuIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processRoleDeleted(Long roleId) {
        this.userRoleMapper.deleteListByRoleId(roleId);
        this.roleMenuMapper.deleteListByRoleId(roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processMenuDeleted(Long menuId) {
        this.roleMenuMapper.deleteListByMenuId(menuId);
    }

    @Override
    public void processUserDeleted(Long userId) {
        this.userRoleMapper.deleteListByUserId(userId);
    }

    public boolean hasPermission(String permission) {
        return this.hasAnyPermissions(permission);
    }

    public boolean hasAnyPermissions(String ... permissions) {
        if (ArrayUtil.isEmpty((Object[])permissions)) {
            return true;
        }
        if (Objects.isNull(SecurityFrameworkUtils.getLoginUser())) {
            return false;
        }
        Set<Long> roleIds = this.getUserRoleIds(SecurityFrameworkUtils.getLoginUserId(), SetUtils.asSet((Object[])new Integer[]{CommonStatus.enabled.status()}));
        if (CollUtil.isEmpty(roleIds)) {
            return false;
        }
        if (this.roleService.hasAnyAdmin(roleIds)) {
            return true;
        }
        return Arrays.stream(permissions).anyMatch(permission -> {
            List<Menu> menuList = this.menuService.getMenuListByPermissionFromCache((String)permission);
            if (CollUtil.isEmpty(menuList)) {
                return false;
            }
            return menuList.stream().anyMatch(menu -> CollUtil.containsAny((Collection)roleIds, (Collection)this.menuRoleCache.get((Object)((Long)menu.getId()))));
        });
    }

    public boolean hasRole(String role) {
        return this.hasAnyRoles(role);
    }

    public boolean hasAnyRoles(String ... roles) {
        if (ArrayUtil.isEmpty((Object[])roles)) {
            return true;
        }
        if (Objects.isNull(SecurityFrameworkUtils.getLoginUser())) {
            return false;
        }
        Set<Long> roleIds = this.getUserRoleIds(SecurityFrameworkUtils.getLoginUserId(), SetUtils.asSet((Object[])new Integer[]{CommonStatus.enabled.status()}));
        if (CollUtil.isEmpty(roleIds)) {
            return false;
        }
        if (this.roleService.hasAnyAdmin(roleIds)) {
            return true;
        }
        Set userRoles = CollectionUtils.convertSet(this.roleService.getRolesFromCache(roleIds), Role::getCode);
        return CollUtil.containsAny((Collection)userRoles, (Collection)Sets.newHashSet((Object[])roles));
    }
}

