/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.sys.permission;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.infra.controller.sys.permission.role.vo.RoleQueryReqVO;
import xyz.migoo.framework.infra.dal.dataobject.sys.Role;
import xyz.migoo.framework.infra.dal.mapper.sys.RoleMapper;
import xyz.migoo.framework.infra.enums.RoleCodeEnum;
import xyz.migoo.framework.infra.enums.RoleTypeEnum;
import xyz.migoo.framework.infra.enums.SysErrorCodeConstants;
import xyz.migoo.framework.infra.service.sys.permission.PermissionService;
import xyz.migoo.framework.infra.service.sys.permission.RoleService;
import xyz.migoo.framework.mybatis.core.dataobject.BaseDO;

@Service
public class RoleServiceImpl
implements RoleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    private static final long SCHEDULER_PERIOD = 300000L;
    private volatile Map<Long, Role> roleCache;
    private volatile LocalDateTime maxUpdateTime;
    @Resource
    @Lazy
    private PermissionService permissionService;
    @Resource
    private RoleMapper roleMapper;

    @Override
    @PostConstruct
    public void initLocalCache() {
        List<Role> roleList = this.loadRoleIfUpdate(this.maxUpdateTime);
        if (CollUtil.isEmpty(roleList)) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        roleList.forEach(sysRoleDO -> builder.put((Object)((Long)sysRoleDO.getId()), (Object)sysRoleDO));
        this.roleCache = builder.build();
        assert (!roleList.isEmpty());
        this.maxUpdateTime = roleList.stream().max(Comparator.comparing(BaseDO::getUpdateTime)).get().getUpdateTime();
        log.info("[initLocalCache][\u521d\u59cb\u5316 Role \u6570\u91cf\u4e3a {}]", (Object)roleList.size());
    }

    @Scheduled(fixedDelay=300000L, initialDelay=300000L)
    public void schedulePeriodicRefresh() {
        this.initLocalCache();
    }

    private List<Role> loadRoleIfUpdate(LocalDateTime maxUpdateTime) {
        if (maxUpdateTime == null) {
            log.info("[loadRoleIfUpdate][\u9996\u6b21\u52a0\u8f7d\u5168\u91cf\u89d2\u8272]");
        } else {
            if (!this.roleMapper.selectExistsByUpdateTimeAfter(maxUpdateTime)) {
                return null;
            }
            log.info("[loadRoleIfUpdate][\u589e\u91cf\u52a0\u8f7d\u5168\u91cf\u89d2\u8272]");
        }
        return this.roleMapper.selectList();
    }

    @Override
    public void updateRoleDataScope(Long id, Integer dataScope, Set<Long> dataScopeDeptIds) {
        this.verify(id);
        Role updateObject = new Role();
        updateObject.setId(id);
        this.roleMapper.updateById((Object)updateObject);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(Long id) {
        this.verify(id);
        this.roleMapper.deleteById(id);
        this.permissionService.processRoleDeleted(id);
    }

    @Override
    public Role getRoleFromCache(Long id) {
        return this.roleCache.get(id);
    }

    @Override
    public List<Role> getRoles(@Nullable Collection<Integer> statuses) {
        return this.roleMapper.selectListByStatus(statuses);
    }

    @Override
    public List<Role> getRolesFromCache(Collection<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.roleCache.values().stream().filter(roleDO -> ids.contains(roleDO.getId())).collect(Collectors.toList());
    }

    @Override
    public boolean hasAnyAdmin(Collection<Role> roleList) {
        if (CollectionUtil.isEmpty(roleList)) {
            return false;
        }
        return roleList.stream().anyMatch(roleDO -> RoleCodeEnum.SUPER_ADMIN.getKey().equals(roleDO.getCode()));
    }

    @Override
    public Role get(Long id) {
        return (Role)((Object)this.roleMapper.selectById(id));
    }

    @Override
    public List<Role> getList(Integer status) {
        return this.roleMapper.selectListByStatus(CollectionUtil.newHashSet((Object[])new Integer[]{status}));
    }

    @Override
    public PageResult<Role> getPage(RoleQueryReqVO req) {
        return this.roleMapper.selectPage(req);
    }

    @Override
    public void verify(String code, String name, Long id) {
        Role role = this.roleMapper.selectByName(name);
        if (role != null && !((Long)role.getId()).equals(id)) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.ROLE_NAME_DUPLICATE, (Object[])new Object[]{name});
        }
        if (!StringUtils.hasText((String)code)) {
            return;
        }
        role = this.roleMapper.selectByCode(code);
        if (role != null && !((Long)role.getId()).equals(id)) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.ROLE_CODE_DUPLICATE, (Object[])new Object[]{code});
        }
    }

    @Override
    public void add(Role role) {
        role.setType(RoleTypeEnum.CUSTOM.getType());
        this.roleMapper.insert((Object)role);
    }

    @Override
    public void update(Role role) {
        this.verify((Long)role.getId());
        this.roleMapper.updateById((Object)role);
    }

    private void verify(Long id) {
        Role roleDO = (Role)((Object)this.roleMapper.selectById(id));
        if (roleDO == null) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.ROLE_NOT_EXISTS);
        }
        if (RoleTypeEnum.SYSTEM.getType().equals(roleDO.getType())) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.ROLE_CAN_NOT_UPDATE_SYSTEM_TYPE_ROLE);
        }
    }
}

