/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.sys.post;

import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;
import xyz.migoo.framework.common.enums.CommonStatus;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.infra.controller.sys.post.vo.PostQueryReqVO;
import xyz.migoo.framework.infra.dal.dataobject.sys.Post;
import xyz.migoo.framework.infra.dal.mapper.sys.PostMapper;
import xyz.migoo.framework.infra.enums.SysErrorCodeConstants;
import xyz.migoo.framework.infra.service.sys.post.PostService;

@Service
public class PostServiceImpl
implements PostService {
    @Resource
    private PostMapper mapper;

    @Override
    public PageResult<Post> getPage(PostQueryReqVO req) {
        return this.mapper.selectPage(req);
    }

    @Override
    public void verify(String code, String name, Long id) {
        if (Objects.nonNull(id)) {
            if (Objects.isNull(this.mapper.selectById(id))) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.POST_NOT_FOUND);
            }
            Post post = this.mapper.selectByCode(code);
            if (Objects.nonNull((Object)post) && !Objects.equals(post.getId(), id)) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.POST_CODE_DUPLICATE);
            }
            post = this.mapper.selectByName(name);
            if (Objects.nonNull((Object)post) && !Objects.equals(post.getId(), id)) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.POST_CODE_DUPLICATE);
            }
        } else {
            Post post = this.mapper.selectByCode(code);
            if (Objects.nonNull((Object)post)) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.POST_CODE_DUPLICATE);
            }
            post = this.mapper.selectByName(name);
            if (Objects.nonNull((Object)post)) {
                throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.POST_CODE_DUPLICATE);
            }
        }
    }

    @Override
    public void add(Post post) {
        post.setStatus(CommonStatus.enabled.status());
        this.mapper.insert((Object)post);
    }

    @Override
    public void update(Post post) {
        this.mapper.updateById((Object)post);
    }

    @Override
    public Post get(Long id) {
        return (Post)((Object)this.mapper.selectById(id));
    }

    @Override
    public void remove(Long id) {
        this.mapper.deleteById(id);
    }

    @Override
    public List<Post> getList(Collection<Long> ids, Collection<Integer> statuses) {
        return this.mapper.selectList(ids, statuses);
    }
}

