/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.framework.infra.service.sys.user;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import xyz.migoo.framework.common.enums.NumberConstants;
import xyz.migoo.framework.common.exception.ErrorCode;
import xyz.migoo.framework.common.exception.util.ServiceExceptionUtil;
import xyz.migoo.framework.common.pojo.PageResult;
import xyz.migoo.framework.infra.controller.login.vo.PasswordVO;
import xyz.migoo.framework.infra.controller.sys.user.vo.UserQueryReqVO;
import xyz.migoo.framework.infra.convert.AuthConvert;
import xyz.migoo.framework.infra.dal.dataobject.sys.User;
import xyz.migoo.framework.infra.dal.mapper.sys.UserMapper;
import xyz.migoo.framework.infra.enums.BindAuthenticatorEnum;
import xyz.migoo.framework.infra.enums.SysErrorCodeConstants;
import xyz.migoo.framework.infra.service.sys.user.UserService;
import xyz.migoo.framework.security.core.BaseUser;
import xyz.migoo.framework.security.core.LoginUser;
import xyz.migoo.framework.security.core.util.GoogleAuthenticator;
import xyz.migoo.framework.security.utils.PasswordUtils;

@Service
public class UserServiceImpl
implements UserService {
    @Resource
    private UserMapper mapper;
    @Value(value="${migoo.security.password-secret}")
    private String secret;

    @Override
    public PageResult<User> getPage(UserQueryReqVO req) {
        return this.mapper.selectPage(req);
    }

    @Override
    public List<User> get(Integer ... status) {
        return this.mapper.selectList(Objects.isNull(status) || status.length < 1 ? null : status[0]);
    }

    @Override
    public User get(String username) {
        User user = this.mapper.selectByUsername(username);
        if (Objects.isNull((Object)user)) {
            throw new UsernameNotFoundException(username);
        }
        if (StrUtil.isNotEmpty((CharSequence)user.getSecretKey())) {
            user.setSecretKey(SecureUtil.aes((byte[])this.secret.getBytes()).decryptStr(user.getSecretKey()));
        }
        return user;
    }

    @Override
    public User get(Long id) {
        return (User)((Object)this.mapper.selectById(id));
    }

    @Override
    public void add(User user) {
        user.setSecretKey(SecureUtil.aes((byte[])this.secret.getBytes()).encryptHex(GoogleAuthenticator.generateSecretKey()));
        user.setPassword(PasswordUtils.encode((String)user.getPassword()));
        this.mapper.insert((Object)user);
    }

    @Override
    public void update(User user) {
        if (StrUtil.isNotBlank((CharSequence)user.getPassword())) {
            user.setPassword(PasswordUtils.encode((String)user.getPassword()));
        }
        if (this.mapper.updateById((Object)user) == NumberConstants.N_0.intValue()) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.USER_NOT_EXISTS);
        }
    }

    @Override
    public void remove(Long id) {
        if (this.mapper.deleteById(id) == NumberConstants.N_0.intValue()) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.USER_NOT_EXISTS);
        }
    }

    @Override
    public void verify(String username) {
        if (Objects.nonNull((Object)this.mapper.selectByUsername(username))) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.USER_IS_EXISTS);
        }
    }

    @Override
    public void update(PasswordVO password) {
        User user = (User)((Object)this.mapper.selectById(password.getId()));
        if (!PasswordUtils.verify((String)password.getOldPassword(), (String)user.getPassword())) {
            throw ServiceExceptionUtil.get((ErrorCode)SysErrorCodeConstants.USER_ORIGINAL_PASSWORD_UNCONFORMITY);
        }
        user.setPassword(PasswordUtils.encode((String)password.getNewPassword()));
        this.mapper.updateById((Object)user);
    }

    @Override
    public void resetAuthenticator(Long id) {
        this.mapper.updateById((Object)((User)new User().setSecretKey(SecureUtil.aes((byte[])this.secret.getBytes()).encryptHex(GoogleAuthenticator.generateSecretKey())).setBindAuthenticator(BindAuthenticatorEnum.INIT.getNumber()).setId(id)));
    }

    public LoginUser toLoginUser(BaseUser<?> baseUser) {
        return AuthConvert.INSTANCE.convert(baseUser);
    }
}

