/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.net.BindException;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.lang.FileSize;
import xyz.noark.core.network.TcpServer;
import xyz.noark.log.LogHelper;
import xyz.noark.network.InitializeDecoder;
import xyz.noark.network.InitializeHandlerManager;
import xyz.noark.network.NettyServerHandler;
import xyz.noark.network.NetworkConstant;
import xyz.noark.network.log.NetworkLoggingHandler;

public class NettyServer
implements TcpServer {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workGroup;
    @Value(value="network.tcp.active")
    protected boolean tcpActive = true;
    @Value(value="network.port")
    protected int port = 9527;
    @Value(value="network.heartbeat")
    protected int heartbeat = 0;
    @Value(value="network.workthreads")
    protected int workThreads = 0;
    @Value(value="network.log.enabled")
    protected boolean logEnabled = false;
    @Value(value="network.epoll.active")
    protected boolean epollActive = true;
    @Value(value="network.low.water.mark")
    private FileSize defaultLowWaterMark = new FileSize(262144L);
    @Value(value="network.high.water.mark")
    private FileSize defaultHighWaterMark = new FileSize(524288L);
    @Autowired
    protected NettyServerHandler nettyServerHandler;
    @Autowired
    protected InitializeHandlerManager initializeHandlerManager;

    public void startup() {
        int nThreads;
        if (!this.tcpActive) {
            return;
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        int n = nThreads = this.workThreads <= 0 ? NetworkConstant.DEFAULT_EVENT_LOOP_THREADS : this.workThreads;
        if (this.epollActive && Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(1);
            this.workGroup = new EpollEventLoopGroup(nThreads);
            bootstrap.group(this.bossGroup, this.workGroup).channel(EpollServerSocketChannel.class);
        } else {
            this.bossGroup = new NioEventLoopGroup(1);
            this.workGroup = new NioEventLoopGroup(nThreads);
            bootstrap.group(this.bossGroup, this.workGroup).channel(NioServerSocketChannel.class);
        }
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)65535);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.defaultLowWaterMark.intValue(), this.defaultHighWaterMark.intValue()));
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                NettyServer.this.buildChannelPipeline(ch.pipeline());
            }
        });
        LogHelper.logger.info("game tcp server start on {}", new Object[]{this.port});
        try {
            bootstrap.bind(this.port).sync();
            LogHelper.logger.info("game tcp server start is success.");
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                throw new ServerBootstrapException("\u76ee\u6807\u7aef\u53e3\u5df2\u88ab\u5360\u7528 port=" + this.port, e);
            }
            throw new ServerBootstrapException("\u672a\u77e5\u5f02\u5e38", e);
        }
    }

    protected void buildChannelPipeline(ChannelPipeline pipeline) {
        if (this.heartbeat > 0) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler((long)this.heartbeat, 0L, 0L, TimeUnit.SECONDS));
        }
        if (this.logEnabled) {
            pipeline.addLast("logger", (ChannelHandler)new NetworkLoggingHandler());
        }
        pipeline.addLast(new ChannelHandler[]{this.nettyServerHandler});
        pipeline.addLast(new ChannelHandler[]{new InitializeDecoder(this.initializeHandlerManager)});
    }

    public void shutdown() {
        if (this.tcpActive) {
            Future boosFuture = this.bossGroup.shutdownGracefully();
            Future workFuture = this.workGroup.shutdownGracefully();
            try {
                if (boosFuture.await(1L, TimeUnit.MINUTES)) {
                    LogHelper.logger.info("NettyBoss\u5173\u95ed\u6210\u529f.");
                }
                if (workFuture.await(1L, TimeUnit.MINUTES)) {
                    LogHelper.logger.info("NettyWork\u5173\u95ed\u6210\u529f.");
                }
            }
            catch (InterruptedException ie) {
                LogHelper.logger.error("\u5173\u95ed\u7f51\u7edc\u65f6\u53d1\u751f\u5f02\u5e38.", new Object[]{ie});
            }
        }
    }
}

