/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.controller.RequestBody;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.exception.ExceptionHelper;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.ioc.manager.HttpMethodManager;
import xyz.noark.core.ioc.wrap.method.HttpMethodWrapper;
import xyz.noark.core.ioc.wrap.param.HttpParamWrapper;
import xyz.noark.core.thread.ThreadDispatcher;
import xyz.noark.core.util.DateUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;
import xyz.noark.network.http.DefaultViewResolver;
import xyz.noark.network.http.HandleInterceptChain;
import xyz.noark.network.http.HttpResult;
import xyz.noark.network.http.HttpServletRequest;
import xyz.noark.network.http.HttpServletResponse;
import xyz.noark.network.http.NoarkHttpServletRequest;
import xyz.noark.network.http.NoarkHttpServletResponse;
import xyz.noark.network.http.ViewResolver;
import xyz.noark.network.http.exception.HandlerDeprecatedException;
import xyz.noark.network.http.exception.NoHandlerFoundException;
import xyz.noark.network.http.exception.UnrealizedQueueIdException;
import xyz.noark.network.util.NettyUtils;

@ChannelHandler.Sharable
public class DispatcherServlet
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final ViewResolver viewResolver = new DefaultViewResolver();
    @Autowired
    private ThreadDispatcher threadDispatcher;
    @Autowired
    private HandleInterceptChain handleInterceptChain;

    public void channelActive(ChannelHandlerContext ctx) {
        LogHelper.logger.debug("http client active. channel={}", new Object[]{ctx.channel()});
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LogHelper.logger.debug("http client inactive. channel={}", new Object[]{ctx.channel()});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof IOException) {
            return;
        }
        LogHelper.logger.error("\u672a\u5904\u7406\u7684\u5f02\u5e38={}", new Object[]{cause});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest fhr) {
        String ip = NettyUtils.analyzeIp(fhr, ctx);
        QueryStringDecoder decoder = new QueryStringDecoder(fhr.uri());
        NoarkHttpServletRequest request = new NoarkHttpServletRequest(decoder.path(), fhr.method(), ip);
        NoarkHttpServletResponse response = new NoarkHttpServletResponse(ctx, HttpUtil.isKeepAlive((HttpMessage)fhr));
        HttpMethodWrapper handler = HttpMethodManager.getHttpHandler((String)request.getMethod(), (String)request.getUri());
        boolean dispatchException = false;
        try {
            request.parse(fhr, decoder);
            this.doDispatch(request, response, handler);
        }
        catch (Throwable e) {
            dispatchException = true;
            this.processHandlerException(request, response, e);
        }
        finally {
            if (dispatchException) {
                response.flush();
            }
        }
    }

    private void doDispatch(HttpServletRequest request, HttpServletResponse response, HttpMethodWrapper handler) {
        if (handler == null) {
            throw new NoHandlerFoundException(request.getMethod(), request.getUri());
        }
        if (handler.isDeprecated()) {
            throw new HandlerDeprecatedException(request.getMethod(), request.getUri());
        }
        Serializable queueId = this.getQueueId(handler, request);
        long createTime = System.nanoTime();
        this.threadDispatcher.dispatch(queueId, () -> this.exec(request, response, handler, createTime), null, false);
    }

    private Serializable getQueueId(HttpMethodWrapper handler, HttpServletRequest request) {
        if (StringUtils.isEmpty((String)handler.getQueueIdKey())) {
            return null;
        }
        String value = request.getParameter(handler.getQueueIdKey());
        if (StringUtils.isEmpty((String)value)) {
            throw new ConvertException("HTTP request param error. uri=" + request.getUri() + "," + handler.getQueueIdKey() + " is required.");
        }
        for (HttpParamWrapper param : handler.getParameters()) {
            if (!handler.getQueueIdKey().equals(param.getName())) continue;
            Converter<?> converter = this.getConverter(param.getParameter());
            try {
                Object result = converter.convert(param.getParameter(), value);
                if (result instanceof Serializable) {
                    return (Serializable)result;
                }
                throw new UnrealizedQueueIdException(request.getMethod(), request.getUri(), handler.getQueueIdKey());
            }
            catch (Exception e) {
                throw new ConvertException("HTTP request param error. uri=" + request.getUri() + " >> " + handler.getQueueIdKey() + " >> " + value + "-->" + converter.buildErrorMsg(), e);
            }
        }
        throw new UnrealizedQueueIdException(request.getMethod(), request.getUri(), handler.getQueueIdKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(HttpServletRequest request, HttpServletResponse response, HttpMethodWrapper handler, long createTime) {
        long startExecuteTime = System.nanoTime();
        try {
            this.doAction(request, response, handler);
        }
        catch (Throwable e) {
            this.processHandlerException(request, response, e);
        }
        finally {
            response.flush();
            if (handler.isPrintLog()) {
                this.handleExecAfter(request, startExecuteTime, createTime);
            }
        }
    }

    private void handleExecAfter(HttpServletRequest request, long startExecuteTime, long createTime) {
        String ip = request.getRemoteAddr();
        float delay = DateUtils.formatNanoTime((long)(startExecuteTime - createTime));
        float exec = DateUtils.formatNanoTime((long)(System.nanoTime() - startExecuteTime));
        LogHelper.logger.info("handle http({}),delay={} ms,exe={} ms,ip={}", new Object[]{request.getUri(), Float.valueOf(delay), Float.valueOf(exec), ip});
    }

    private void processHandlerException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        if (e instanceof NoHandlerFoundException) {
            this.noHandlerFound(request, response);
        } else if (e instanceof HandlerDeprecatedException) {
            this.handleDeprecated(request, response);
        } else if (e instanceof ConvertException) {
            this.handleConvertException(request, response, e);
        } else {
            this.handleServerException(request, response, e);
        }
        ExceptionHelper.monitor((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(HttpServletRequest request, HttpServletResponse response, HttpMethodWrapper handler) throws Exception {
        if (this.handleInterceptChain.triggerPreHandle(request, response, handler)) {
            return;
        }
        try {
            Object result = handler.invoke(this.analysisParam(handler, request));
            this.handleInterceptChain.triggerPostHandle(request, response, handler, result);
            this.render(request, response, handler, result);
        }
        finally {
            this.handleInterceptChain.triggerAfterCompletion(request, response, handler);
        }
    }

    private void render(HttpServletRequest request, HttpServletResponse response, HttpMethodWrapper handler, Object result) {
        this.viewResolver.resolveView(request, response, handler, result);
    }

    private Object[] analysisParam(HttpMethodWrapper handler, HttpServletRequest request) {
        if (handler.getParameters().isEmpty()) {
            return new Object[0];
        }
        ArrayList<Object> args = new ArrayList<Object>(handler.getParameters().size());
        for (HttpParamWrapper param : handler.getParameters()) {
            String data;
            if (HttpServletRequest.class.isAssignableFrom(param.getParameter().getType())) {
                args.add(request);
                continue;
            }
            Converter<?> converter = this.getConverter(param.getParameter());
            RequestBody requestBody = param.getRequestBody();
            if (requestBody == null) {
                data = request.getParameter(param.getName());
            } else {
                try (InputStream inputStream = request.getInputStream();){
                    data = StringUtils.readString((InputStream)inputStream);
                }
                catch (Exception e) {
                    data = null;
                    e.printStackTrace();
                }
                if (requestBody.required() && data == null) {
                    throw new ConvertException("HTTP request body error. uri=" + request.getUri() + "," + param.getName() + " is required.");
                }
            }
            if (data == null) {
                if (param.isRequired()) {
                    throw new ConvertException("HTTP request param error. uri=" + request.getUri() + "," + param.getName() + " is required.");
                }
                try {
                    args.add(converter.convert(param.getParameter(), param.getDefaultValue()));
                    continue;
                }
                catch (Exception e) {
                    throw new ConvertException("HTTP request default param error. uri=" + request.getUri() + "," + param.getName() + "=" + param.getDefaultValue() + "-->" + converter.buildErrorMsg(), e);
                }
            }
            try {
                args.add(converter.convert(param.getParameter(), data));
            }
            catch (Exception e) {
                throw new ConvertException("HTTP request param error. uri=" + request.getUri() + "," + param.getName() + "=" + data + "-->" + converter.buildErrorMsg(), e);
            }
        }
        return args.toArray();
    }

    private Converter<?> getConverter(Parameter field) {
        Converter result = ConvertManager.getInstance().getConverter(field.getType());
        if (result == null) {
            throw new UnrealizedException("\u672a\u5b9e\u73b0\u7684\u6ce8\u5165(" + field.getType().getName() + ")" + field.getName());
        }
        return result;
    }

    private void handleServerException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        LogHelper.logger.warn("internal error for HTTP request with URI [{}] in DispatcherServlet. ip={}{}", new Object[]{request.getUri(), request.getRemoteAddr(), e});
        response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        response.writeObject(new HttpResult(-5, "request's API internal error."));
    }

    private void handleConvertException(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        LogHelper.logger.warn("parameters invalid for HTTP request with URI [{}] in DispatcherServlet. ip={}{}", new Object[]{request.getUri(), request.getRemoteAddr(), e});
        response.setStatus(HttpResponseStatus.BAD_REQUEST.code());
        response.writeObject(new HttpResult(-1, "request's API parameters invalid."));
    }

    private void handleDeprecated(HttpServletRequest request, HttpServletResponse response) {
        LogHelper.logger.warn("deprecated for HTTP request with URI [{}] in DispatcherServlet. ip={}", new Object[]{request.getUri(), request.getRemoteAddr()});
        response.setStatus(HttpResponseStatus.LOCKED.code());
        response.writeObject(new HttpResult(-6, "request's API Deprecated."));
    }

    private void noHandlerFound(HttpServletRequest request, HttpServletResponse response) {
        LogHelper.logger.warn("No mapping found for HTTP request with URI [{}] in DispatcherServlet. ip={}", new Object[]{request.getUri(), request.getRemoteAddr()});
        response.setStatus(HttpResponseStatus.NOT_FOUND.code());
        response.writeObject(new HttpResult(-4, "request's API Unrealized."));
    }
}

