/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.lang.FileSize;
import xyz.noark.core.network.TcpServer;
import xyz.noark.log.LogHelper;
import xyz.noark.network.http.DispatcherServlet;
import xyz.noark.network.log.NetworkLoggingHandler;

public class HttpServer
implements TcpServer {
    private final EventLoopGroup bossGroup = new NioEventLoopGroup(1);
    private final EventLoopGroup workerGroup = new NioEventLoopGroup(4);
    @Value(value="network.http.port")
    private int port = 0;
    @Value(value="network.http.secret.key")
    private String secretKey = null;
    @Value(value="network.log.enabled")
    protected boolean logEnabled = false;
    @Value(value="network.log.output.active")
    protected boolean outputActive = false;
    @Autowired
    private DispatcherServlet dispatcherServlet;
    @Value(value="network.http.max.content.length")
    private FileSize maxContentLength = new FileSize(0x100000L);

    public void setPort(int port) {
        this.port = port;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void startup() {
        if (this.port <= 0) {
            LogHelper.logger.debug("http server not started.");
            return;
        }
        LogHelper.logger.info("http server start on {}", new Object[]{this.port});
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (HttpServer.this.logEnabled) {
                    pipeline.addLast(new ChannelHandler[]{new NetworkLoggingHandler(HttpServer.this.outputActive)});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(HttpServer.this.maxContentLength.intValue())});
                pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
                pipeline.addLast(new ChannelHandler[]{HttpServer.this.dispatcherServlet});
            }
        });
        try {
            bootstrap.bind(this.port).sync();
            LogHelper.logger.info("http server start is success.");
        }
        catch (Exception e) {
            throw new ServerBootstrapException("\u76ee\u6807\u7aef\u53e3\u5df2\u88ab\u5360\u7528 port=" + this.port, e);
        }
    }

    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

