/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.GzipUtils;
import xyz.noark.core.util.MapUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.network.http.HttpServletRequest;
import xyz.noark.network.http.exception.UnrealizedMethodException;
import xyz.noark.network.util.ByteBufUtils;

class NoarkHttpServletRequest
implements HttpServletRequest {
    private final String uri;
    private final String method;
    private final String ip;
    private Map<String, String[]> parameterMap = Collections.emptyMap();
    private InputStream requestBodyInputStream;

    NoarkHttpServletRequest(String uri, HttpMethod method, String ip) {
        this.uri = uri;
        this.method = method.name();
        this.ip = ip;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getParameter(String name) {
        String[] array = this.getParameterValues(name);
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public InputStream getInputStream() {
        return this.requestBodyInputStream;
    }

    @Override
    public String getRemoteAddr() {
        return this.ip;
    }

    public String toString() {
        return "HttpServletRequest [uri=" + this.uri + ", parameters=" + JSON.toJSONString(this.parameterMap) + "]";
    }

    public void parse(FullHttpRequest fhr, QueryStringDecoder decoder) throws IOException {
        HttpMethod method = fhr.method();
        HashMap parameterMap = MapUtils.newHashMap((int)16);
        if (HttpMethod.GET == method) {
            this.parseGetRequestParameter(decoder, parameterMap);
        } else if (HttpMethod.POST == method) {
            this.parseGetRequestParameter(decoder, parameterMap);
            this.parsePostContent(fhr, parameterMap);
        } else {
            throw new UnrealizedMethodException(method.name(), decoder.path());
        }
        HashMap result = MapUtils.newHashMap((int)parameterMap.size());
        for (Map.Entry e : parameterMap.entrySet()) {
            result.put(e.getKey(), ((List)e.getValue()).toArray(new String[0]));
        }
        this.parameterMap = result;
    }

    private void parsePostContent(FullHttpRequest fhr, Map<String, List<String>> parameterMap) throws IOException {
        HttpHeaders headers = fhr.headers();
        String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        String contentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        if (StringUtils.isEmpty((String)contentType)) {
            this.parsePostBodyContent(fhr, contentEncoding);
        } else if ("application/json".equalsIgnoreCase(contentType)) {
            this.parseJsonContent(fhr, parameterMap, contentEncoding);
        } else {
            this.parsePostFromContent(fhr, parameterMap);
        }
    }

    private void parsePostBodyContent(FullHttpRequest fhr, String contentEncoding) throws IOException {
        byte[] content = ByteBufUtils.readBytes(fhr.content());
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            content = GzipUtils.uncompress((byte[])content);
        }
        this.requestBodyInputStream = new ByteArrayInputStream(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePostFromContent(FullHttpRequest fhr, Map<String, List<String>> parameterMap) throws IOException {
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)fhr);
        try {
            List parameterList = decoder.getBodyHttpDatas();
            for (InterfaceHttpData parameter : parameterList) {
                Attribute attr = (Attribute)parameter;
                parameterMap.computeIfAbsent(attr.getName(), key -> new ArrayList(1)).add(attr.getValue());
            }
        }
        finally {
            decoder.destroy();
        }
    }

    private void parseJsonContent(FullHttpRequest fhr, Map<String, List<String>> parameterMap, String contentEncoding) throws IOException {
        JSONObject jsonObject;
        ByteBuf byteBuf = fhr.content();
        if (byteBuf.readableBytes() == 0) {
            return;
        }
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            byte[] content = ByteBufUtils.readBytes(fhr.content());
            content = GzipUtils.uncompress((byte[])content);
            jsonObject = JSON.parseObject((String)new String(content, CharsetUtils.CHARSET_UTF_8));
        } else {
            jsonObject = JSON.parseObject((String)byteBuf.toString(CharsetUtils.CHARSET_UTF_8));
        }
        for (Map.Entry e : jsonObject.entrySet()) {
            parameterMap.computeIfAbsent((String)e.getKey(), (Function<String, List<String>>)((Function<String, List>)key -> new ArrayList(1))).add(e.getValue().toString());
        }
    }

    private void parseGetRequestParameter(QueryStringDecoder decoder, Map<String, List<String>> parameterMap) {
        for (Map.Entry e : decoder.parameters().entrySet()) {
            parameterMap.computeIfAbsent((String)e.getKey(), (Function<String, List<String>>)((Function<String, List>)key -> new ArrayList(((List)e.getValue()).size()))).addAll((Collection)e.getValue());
        }
    }
}

