/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import xyz.noark.core.util.StringUtils;
import xyz.noark.network.http.HttpServletResponse;
import xyz.noark.network.util.ByteBufUtils;

class NoarkHttpServletResponse
implements HttpServletResponse {
    private final ChannelHandlerContext ctx;
    private final boolean keepAlive;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private ByteBuf content;
    private String charset = "UTF-8";
    private String contentType = "application/json";

    NoarkHttpServletResponse(ChannelHandlerContext ctx, boolean keepAlive) {
        this.ctx = ctx;
        this.keepAlive = keepAlive;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    @Override
    public void setStatus(int status) {
        this.status = HttpResponseStatus.valueOf((int)status);
    }

    @Override
    public void writeString(String str) {
        this.content = Unpooled.copiedBuffer((CharSequence)str, (Charset)Charset.forName(this.charset));
    }

    @Override
    public void writeObject(Object o) {
        this.writeString(JSON.toJSONString((Object)o));
    }

    @Override
    public void flush() {
        this.sendAndClose();
    }

    private void sendAndClose() {
        FullHttpResponse response = this.createResponse();
        this.fillResponseHeaderInfo(response.headers());
        if (this.keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            this.ctx.writeAndFlush((Object)response);
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void fillResponseHeaderInfo(HttpHeaders httpHeaders) {
        httpHeaders.set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)StringUtils.join((String[])new String[]{this.contentType, ";charset=", this.charset}));
        httpHeaders.set(HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)ByteBufUtils.size(this.content));
    }

    private FullHttpResponse createResponse() {
        HttpVersion version = HttpVersion.HTTP_1_1;
        ByteBuf buf = this.content == null ? Unpooled.EMPTY_BUFFER : this.content;
        return new DefaultFullHttpResponse(version, this.status, buf);
    }

    public void setContent(ByteBuf content) {
        this.content = content;
    }
}

