/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.http.intercept;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.noark.core.annotation.controller.IpAllowList;
import xyz.noark.core.env.EnvConfigHolder;
import xyz.noark.core.network.HandlerMethod;
import xyz.noark.core.util.IpUtils;
import xyz.noark.network.http.HandlerInterceptorAdapter;
import xyz.noark.network.http.HttpResult;
import xyz.noark.network.http.HttpServletRequest;
import xyz.noark.network.http.HttpServletResponse;
import xyz.noark.network.http.intercept.IpAllowListConfig;

public class IpIntercept
extends HandlerInterceptorAdapter {
    private final Map<String, IpAllowListConfig> cache = new ConcurrentHashMap<String, IpAllowListConfig>();

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler) {
        String ip = request.getRemoteAddr();
        IpAllowList allowList = (IpAllowList)handler.getAnnotation(IpAllowList.class);
        if (allowList == null) {
            if (!IpUtils.isInnerIp((String)ip)) {
                return this.notAccess(response);
            }
        } else {
            String value = allowList.value();
            if ("*".equals(value)) {
                return true;
            }
            IpAllowListConfig config = this.cache.computeIfAbsent(value, this::createIpWhiterListConfig);
            if (config.notAccess(ip)) {
                return this.notAccess(response);
            }
        }
        return true;
    }

    private boolean notAccess(HttpServletResponse response) {
        response.setStatus(HttpResponseStatus.UNAUTHORIZED.code());
        response.writeObject(new HttpResult(-2, "request's API not authorized."));
        return false;
    }

    private IpAllowListConfig createIpWhiterListConfig(String key) {
        return new IpAllowListConfig(EnvConfigHolder.getString((String)key));
    }
}

