/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.log;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.StringUtil;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.Logger;
import xyz.noark.log.LoggerFactory;

@ChannelHandler.Sharable
public class NetworkLoggingHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(NetworkLoggingHandler.class);
    private boolean outputActive = true;

    public NetworkLoggingHandler() {
    }

    public NetworkLoggingHandler(boolean outputActive) {
        this.outputActive = outputActive;
    }

    public void setOutputActive(boolean outputActive) {
        this.outputActive = outputActive;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.outputActive && logger.isInfoEnabled()) {
            logger.info(this.format(ctx, "READ", msg));
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.outputActive && logger.isInfoEnabled()) {
            logger.info(this.format(ctx, "WRITE", msg));
        }
        ctx.write(msg, promise);
    }

    protected String format(ChannelHandlerContext ctx, String eventName, Object arg) {
        if (arg instanceof ByteBuf) {
            return this.formatByteBuf(ctx, eventName, (ByteBuf)arg);
        }
        if (arg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(ctx, eventName, (ByteBufHolder)arg);
        }
        return NetworkLoggingHandler.formatSimple(ctx, eventName, arg);
    }

    private String formatByteBuf(ChannelHandlerContext ctx, String eventName, ByteBuf msg) {
        String chStr = ctx.channel().toString();
        int length = msg.readableBytes();
        if (length == 0) {
            return StringUtils.join((String[])new String[]{chStr, " ", eventName, ": 0B"});
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + 10 + 1;
        StringBuilder sb = new StringBuilder(outputLength += this.calHexDumpLength(length));
        sb.append(chStr).append(' ').append(eventName).append(": ").append(length).append('B');
        sb.append(StringUtil.NEWLINE);
        ByteBufUtil.appendPrettyHexDump((StringBuilder)sb, (ByteBuf)msg);
        return sb.toString();
    }

    private int calHexDumpLength(int length) {
        return 2 + (length / 16 + (length % 15 == 0 ? 0 : 1) + 4) * 80;
    }

    private String formatByteBufHolder(ChannelHandlerContext ctx, String eventName, ByteBufHolder msg) {
        String chStr = ctx.channel().toString();
        String msgStr = msg.toString();
        ByteBuf content = msg.content();
        int length = content.readableBytes();
        if (length == 0) {
            return StringUtils.join((String[])new String[]{chStr, " ", eventName, ", ", msgStr, ", 0B"});
        }
        int outputLength = chStr.length() + 1 + eventName.length() + 2 + msgStr.length() + 2 + 10 + 1;
        StringBuilder sb = new StringBuilder(outputLength += this.calHexDumpLength(length));
        sb.append(chStr).append(' ').append(eventName).append(": ").append(msgStr).append(", ").append(length).append('B');
        sb.append(StringUtil.NEWLINE);
        ByteBufUtil.appendPrettyHexDump((StringBuilder)sb, (ByteBuf)content);
        return sb.toString();
    }

    private static String formatSimple(ChannelHandlerContext ctx, String eventName, Object msg) {
        String chStr = ctx.channel().toString();
        String msgStr = String.valueOf(msg);
        return StringUtils.join((String[])new String[]{chStr, " ", eventName, ": ", msgStr});
    }
}

