/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.network.util;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.SocketAddress;
import xyz.noark.core.util.IpUtils;
import xyz.noark.core.util.StringUtils;

public class NettyUtils {
    private static final String UNKNOWN = "unknown";

    public static String analyzeIp(FullHttpRequest fhr, ChannelHandlerContext ctx) {
        HttpHeaders headers = fhr.headers();
        String ip = headers.get("X-Real-IP");
        if (StringUtils.isNotEmpty((String)ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = headers.get("X-Forwarded-For");
        if (StringUtils.isNotEmpty((String)ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = headers.get("Proxy-Client-IP");
        if (StringUtils.isNotEmpty((String)ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = headers.get("WL-Proxy-Client-IP");
        if (StringUtils.isNotEmpty((String)ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = IpUtils.getIp((SocketAddress)ctx.channel().remoteAddress());
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip;
    }
}

