/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.ressor.source.AbstractSource;
import xyz.ressor.source.LoadedResource;
import xyz.ressor.source.NonListenableSource;
import xyz.ressor.source.ResourceId;
import xyz.ressor.source.SourceVersion;
import xyz.ressor.source.s3.S3ResourceId;
import xyz.ressor.source.s3.version.S3Version;
import xyz.ressor.source.s3.version.VersionType;

public class S3Source
extends AbstractSource<S3ResourceId>
implements NonListenableSource<S3ResourceId> {
    private static final Logger log = LoggerFactory.getLogger(S3Source.class);
    private final AmazonS3 client;

    public S3Source(AmazonS3 client) {
        this.client = Objects.requireNonNull(client, "Amazon S3 client is required");
    }

    public LoadedResource loadIfModified(S3ResourceId resourceId, SourceVersion version) {
        S3Object response;
        S3ObjectId objectId = resourceId.getObjectId();
        GetObjectRequest request = new GetObjectRequest(objectId);
        if (!version.isEmpty()) {
            Object val;
            VersionType type = ((S3Version)version).getType();
            if (type == VersionType.ETAG) {
                val = (String)version.val();
                request.setNonmatchingETagConstraints(Collections.singletonList(val));
            } else if (type == VersionType.LAST_MODIFIED) {
                val = (Date)version.val();
                request.setModifiedSinceConstraint((Date)val);
            }
        }
        if ((response = this.client.getObject(request)) != null) {
            S3Version resultVersion;
            String eTag = response.getObjectMetadata().getETag();
            if (StringUtils.isNullOrEmpty((String)eTag)) {
                Date lastModified = response.getObjectMetadata().getLastModified();
                if (lastModified != null) {
                    log.debug("Loaded Last-Modified version for {}: {}", (Object)objectId, (Object)eTag);
                    resultVersion = new S3Version(lastModified, VersionType.LAST_MODIFIED);
                } else {
                    log.debug("No resource version was found for {}", (Object)objectId);
                    resultVersion = SourceVersion.EMPTY;
                }
            } else {
                log.debug("Loaded ETag version for {}: {}", (Object)objectId, (Object)eTag);
                resultVersion = new S3Version(eTag, VersionType.ETAG);
            }
            return new LoadedResource((InputStream)response.getObjectContent(), (SourceVersion)resultVersion, (ResourceId)resourceId);
        }
        return null;
    }

    public String describe() {
        return "S3";
    }
}

