/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import xyz.ressor.source.s3.S3Source;

public class S3SourceBuilder {
    private AWSCredentialsProvider credentialsProvider;
    private ClientConfiguration clientConfiguration;
    private Regions region;
    private String versionId;

    public S3SourceBuilder credentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public S3SourceBuilder credentials(AWSCredentials credentials) {
        this.credentialsProvider = new AWSStaticCredentialsProvider(credentials);
        return this;
    }

    public S3SourceBuilder credentials(String accessKey, String secretKey) {
        this.credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        return this;
    }

    public S3SourceBuilder region(Regions region) {
        this.region = region;
        return this;
    }

    public S3SourceBuilder region(String region) {
        this.region = Regions.fromName((String)region.toLowerCase());
        return this;
    }

    public S3SourceBuilder clientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this;
    }

    public S3SourceBuilder versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public S3Source build() {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (this.credentialsProvider != null) {
            builder.withCredentials(this.credentialsProvider);
        }
        if (this.clientConfiguration != null) {
            builder.withClientConfiguration(this.clientConfiguration);
        }
        if (this.region != null) {
            builder.withRegion(this.region);
        }
        return new S3Source((AmazonS3)builder.build());
    }
}

