/*
 * Decompiled with CFR 0.152.
 */
package io.eden.mybatis.starter;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.eden.common.core.exception.ApplicationException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.util.CollectionUtils;

public final class MybatisUtils {
    public static <T> T getOne(List<T> list) throws ApplicationException {
        if (CollectionUtils.isEmpty(list)) {
            throw new ApplicationException("\u6570\u636e\u96c6\u4e3a\u7a7a");
        }
        return list.get(0);
    }

    public static String generateResultMap(String resultMapName, Class origin) {
        StringBuilder sb = new StringBuilder();
        sb.append("@Results(id = \"" + resultMapName + "\", value = {\n");
        List fields = FieldUtils.getAllFieldsList((Class)origin);
        for (Field field : fields) {
            String property = field.getName();
            if (property.equals("serialVersionUID")) continue;
            String column = new PropertyNamingStrategy.SnakeCaseStrategy().translate(field.getName()).toLowerCase();
            sb.append(String.format("@Result(property = \"%s\", column = \"%s\"),\n", property, column));
        }
        sb.deleteCharAt(sb.length() - 2);
        sb.append("})");
        System.out.println(sb);
        return sb.toString();
    }

    public static String reformatSQLCopiedFromNavicat(String raw) {
        raw = raw.replaceAll("\t", "  ");
        String[] split = raw.split("\n");
        String PREFIX = "\"";
        String result = "";
        for (String s : split) {
            result = result + "\"" + " " + s + " " + "\"" + ",\n";
        }
        result = result.substring(0, result.length() - 2);
        System.out.println(result);
        return result;
    }

    private MybatisUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

