/*
 * Decompiled with CFR 0.152.
 */
package io.eden.mybatis.starter;

import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.List;

public class Paging<T>
implements Serializable {
    private static final long serialVersionUID = 9065754951045767059L;
    private int pageNum;
    private int pageSize;
    private long recordTotal;
    private int pageTotal;
    private List<T> data;

    public Paging(List<T> data) {
        this.data = data;
    }

    public static <T> Paging<T> convert(PageInfo<T> info) {
        Paging<T> paging = new Paging<T>(info.getList());
        paging.setPageNum(info.getPageNum());
        paging.setPageSize(info.getPageSize());
        paging.setRecordTotal(info.getTotal());
        paging.setPageTotal(info.getPages());
        return paging;
    }

    public static <T> Paging<T> convert(List<T> data) {
        PageInfo info = new PageInfo(data);
        return Paging.convert(info);
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getRecordTotal() {
        return this.recordTotal;
    }

    public int getPageTotal() {
        return this.pageTotal;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRecordTotal(long recordTotal) {
        this.recordTotal = recordTotal;
    }

    public void setPageTotal(int pageTotal) {
        this.pageTotal = pageTotal;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Paging)) {
            return false;
        }
        Paging other = (Paging)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getRecordTotal() != other.getRecordTotal()) {
            return false;
        }
        if (this.getPageTotal() != other.getPageTotal()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Paging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        long $recordTotal = this.getRecordTotal();
        result = result * 59 + (int)($recordTotal >>> 32 ^ $recordTotal);
        result = result * 59 + this.getPageTotal();
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Paging(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", recordTotal=" + this.getRecordTotal() + ", pageTotal=" + this.getPageTotal() + ", data=" + this.getData() + ")";
    }

    public Paging() {
    }
}

