/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationinsights.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.applicationinsights.model.ApplicationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ApplicationInfo> applicationInfoList;
    private String nextToken;

    public List<ApplicationInfo> getApplicationInfoList() {
        return this.applicationInfoList;
    }

    public void setApplicationInfoList(Collection<ApplicationInfo> applicationInfoList) {
        if (applicationInfoList == null) {
            this.applicationInfoList = null;
            return;
        }
        this.applicationInfoList = new ArrayList<ApplicationInfo>(applicationInfoList);
    }

    public ListApplicationsResult withApplicationInfoList(ApplicationInfo ... applicationInfoList) {
        if (this.applicationInfoList == null) {
            this.setApplicationInfoList(new ArrayList<ApplicationInfo>(applicationInfoList.length));
        }
        for (ApplicationInfo ele : applicationInfoList) {
            this.applicationInfoList.add(ele);
        }
        return this;
    }

    public ListApplicationsResult withApplicationInfoList(Collection<ApplicationInfo> applicationInfoList) {
        this.setApplicationInfoList(applicationInfoList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListApplicationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationInfoList() != null) {
            sb.append("ApplicationInfoList: ").append(this.getApplicationInfoList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResult)) {
            return false;
        }
        ListApplicationsResult other = (ListApplicationsResult)obj;
        if (other.getApplicationInfoList() == null ^ this.getApplicationInfoList() == null) {
            return false;
        }
        if (other.getApplicationInfoList() != null && !other.getApplicationInfoList().equals(this.getApplicationInfoList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationInfoList() == null ? 0 : this.getApplicationInfoList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListApplicationsResult clone() {
        try {
            return (ListApplicationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

