/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.panorama.model.PackageListItem;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class PackageListItemMarshaller {
    private static final MarshallingInfo<String> PACKAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageId").build();
    private static final MarshallingInfo<String> PACKAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageName").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final PackageListItemMarshaller instance = new PackageListItemMarshaller();

    public static PackageListItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(PackageListItem packageListItem, ProtocolMarshaller protocolMarshaller) {
        if (packageListItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)packageListItem.getPackageId(), PACKAGEID_BINDING);
            protocolMarshaller.marshall((Object)packageListItem.getPackageName(), PACKAGENAME_BINDING);
            protocolMarshaller.marshall((Object)packageListItem.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)packageListItem.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(packageListItem.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

