/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.util.json.SdkJsonGenerator;

public class PortMappingJsonMarshaller {
    private static PortMappingJsonMarshaller instance;

    public void marshall(PortMapping portMapping, SdkJsonGenerator jsonGenerator) {
        if (portMapping == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (portMapping.getContainerPort() != null) {
                jsonGenerator.writeFieldName("containerPort").writeValue((long)portMapping.getContainerPort().intValue());
            }
            if (portMapping.getHostPort() != null) {
                jsonGenerator.writeFieldName("hostPort").writeValue((long)portMapping.getHostPort().intValue());
            }
            if (portMapping.getProtocol() != null) {
                jsonGenerator.writeFieldName("protocol").writeValue(portMapping.getProtocol());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PortMappingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PortMappingJsonMarshaller();
        }
        return instance;
    }
}

