/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.Deployment;
import java.util.Date;

@SdkInternalApi
public class DeploymentMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> TASKDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskDefinition").build();
    private static final MarshallingInfo<Integer> DESIREDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredCount").build();
    private static final MarshallingInfo<Integer> PENDINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pendingCount").build();
    private static final MarshallingInfo<Integer> RUNNINGCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("runningCount").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updatedAt").build();
    private static final DeploymentMarshaller instance = new DeploymentMarshaller();

    public static DeploymentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Deployment deployment, ProtocolMarshaller protocolMarshaller) {
        if (deployment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deployment.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)deployment.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)deployment.getTaskDefinition(), TASKDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)deployment.getDesiredCount(), DESIREDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)deployment.getPendingCount(), PENDINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)deployment.getRunningCount(), RUNNINGCOUNT_BINDING);
            protocolMarshaller.marshall((Object)deployment.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)deployment.getUpdatedAt(), UPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

