/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.ContainerStateChange;
import java.util.List;

@SdkInternalApi
public class ContainerStateChangeMarshaller {
    private static final MarshallingInfo<String> CONTAINERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerName").build();
    private static final MarshallingInfo<Integer> EXITCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exitCode").build();
    private static final MarshallingInfo<List> NETWORKBINDINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkBindings").build();
    private static final MarshallingInfo<String> REASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reason").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final ContainerStateChangeMarshaller instance = new ContainerStateChangeMarshaller();

    public static ContainerStateChangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerStateChange containerStateChange, ProtocolMarshaller protocolMarshaller) {
        if (containerStateChange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)containerStateChange.getContainerName(), CONTAINERNAME_BINDING);
            protocolMarshaller.marshall((Object)containerStateChange.getExitCode(), EXITCODE_BINDING);
            protocolMarshaller.marshall(containerStateChange.getNetworkBindings(), NETWORKBINDINGS_BINDING);
            protocolMarshaller.marshall((Object)containerStateChange.getReason(), REASON_BINDING);
            protocolMarshaller.marshall((Object)containerStateChange.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

