/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.ProxyConfigurationType;
import com.amazonaws.services.ecs.model.transform.ProxyConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ProxyConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String containerName;
    private SdkInternalList<KeyValuePair> properties;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ProxyConfiguration withType(String type) {
        this.setType(type);
        return this;
    }

    public ProxyConfiguration withType(ProxyConfigurationType type) {
        this.type = type.toString();
        return this;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public ProxyConfiguration withContainerName(String containerName) {
        this.setContainerName(containerName);
        return this;
    }

    public List<KeyValuePair> getProperties() {
        if (this.properties == null) {
            this.properties = new SdkInternalList();
        }
        return this.properties;
    }

    public void setProperties(Collection<KeyValuePair> properties) {
        if (properties == null) {
            this.properties = null;
            return;
        }
        this.properties = new SdkInternalList(properties);
    }

    public ProxyConfiguration withProperties(KeyValuePair ... properties) {
        if (this.properties == null) {
            this.setProperties((Collection<KeyValuePair>)new SdkInternalList(properties.length));
        }
        for (KeyValuePair ele : properties) {
            this.properties.add((Object)ele);
        }
        return this;
    }

    public ProxyConfiguration withProperties(Collection<KeyValuePair> properties) {
        this.setProperties(properties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getContainerName() != null) {
            sb.append("ContainerName: ").append(this.getContainerName()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getContainerName() == null ^ this.getContainerName() == null) {
            return false;
        }
        if (other.getContainerName() != null && !other.getContainerName().equals(this.getContainerName())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getContainerName() == null ? 0 : this.getContainerName().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public ProxyConfiguration clone() {
        try {
            return (ProxyConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProxyConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

