/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Cluster;

public class ClusterJsonMarshaller {
    private static ClusterJsonMarshaller instance;

    public void marshall(Cluster cluster, StructuredJsonGenerator jsonGenerator) {
        if (cluster == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (cluster.getClusterArn() != null) {
                jsonGenerator.writeFieldName("clusterArn").writeValue(cluster.getClusterArn());
            }
            if (cluster.getClusterName() != null) {
                jsonGenerator.writeFieldName("clusterName").writeValue(cluster.getClusterName());
            }
            if (cluster.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(cluster.getStatus());
            }
            if (cluster.getRegisteredContainerInstancesCount() != null) {
                jsonGenerator.writeFieldName("registeredContainerInstancesCount").writeValue(cluster.getRegisteredContainerInstancesCount().intValue());
            }
            if (cluster.getRunningTasksCount() != null) {
                jsonGenerator.writeFieldName("runningTasksCount").writeValue(cluster.getRunningTasksCount().intValue());
            }
            if (cluster.getPendingTasksCount() != null) {
                jsonGenerator.writeFieldName("pendingTasksCount").writeValue(cluster.getPendingTasksCount().intValue());
            }
            if (cluster.getActiveServicesCount() != null) {
                jsonGenerator.writeFieldName("activeServicesCount").writeValue(cluster.getActiveServicesCount().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterJsonMarshaller();
        }
        return instance;
    }
}

