/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.transform.KeyValuePairJsonMarshaller;

public class ContainerOverrideJsonMarshaller {
    private static ContainerOverrideJsonMarshaller instance;

    public void marshall(ContainerOverride containerOverride, StructuredJsonGenerator jsonGenerator) {
        if (containerOverride == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList environmentList;
            SdkInternalList commandList;
            jsonGenerator.writeStartObject();
            if (containerOverride.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(containerOverride.getName());
            }
            if (!(commandList = (SdkInternalList)containerOverride.getCommand()).isEmpty() || !commandList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("command");
                jsonGenerator.writeStartArray();
                for (String commandListValue : commandList) {
                    if (commandListValue == null) continue;
                    jsonGenerator.writeValue(commandListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(environmentList = (SdkInternalList)containerOverride.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("environment");
                jsonGenerator.writeStartArray();
                for (KeyValuePair environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    KeyValuePairJsonMarshaller.getInstance().marshall(environmentListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerOverrideJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerOverrideJsonMarshaller();
        }
        return instance;
    }
}

