/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.CPUArchitecture;
import com.amazonaws.services.ecs.model.OSFamily;
import com.amazonaws.services.ecs.model.transform.RuntimePlatformMarshaller;
import java.io.Serializable;

public class RuntimePlatform
implements Serializable,
Cloneable,
StructuredPojo {
    private String cpuArchitecture;
    private String operatingSystemFamily;

    public void setCpuArchitecture(String cpuArchitecture) {
        this.cpuArchitecture = cpuArchitecture;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public RuntimePlatform withCpuArchitecture(String cpuArchitecture) {
        this.setCpuArchitecture(cpuArchitecture);
        return this;
    }

    public RuntimePlatform withCpuArchitecture(CPUArchitecture cpuArchitecture) {
        this.cpuArchitecture = cpuArchitecture.toString();
        return this;
    }

    public void setOperatingSystemFamily(String operatingSystemFamily) {
        this.operatingSystemFamily = operatingSystemFamily;
    }

    public String getOperatingSystemFamily() {
        return this.operatingSystemFamily;
    }

    public RuntimePlatform withOperatingSystemFamily(String operatingSystemFamily) {
        this.setOperatingSystemFamily(operatingSystemFamily);
        return this;
    }

    public RuntimePlatform withOperatingSystemFamily(OSFamily operatingSystemFamily) {
        this.operatingSystemFamily = operatingSystemFamily.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCpuArchitecture() != null) {
            sb.append("CpuArchitecture: ").append(this.getCpuArchitecture()).append(",");
        }
        if (this.getOperatingSystemFamily() != null) {
            sb.append("OperatingSystemFamily: ").append(this.getOperatingSystemFamily());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimePlatform)) {
            return false;
        }
        RuntimePlatform other = (RuntimePlatform)obj;
        if (other.getCpuArchitecture() == null ^ this.getCpuArchitecture() == null) {
            return false;
        }
        if (other.getCpuArchitecture() != null && !other.getCpuArchitecture().equals(this.getCpuArchitecture())) {
            return false;
        }
        if (other.getOperatingSystemFamily() == null ^ this.getOperatingSystemFamily() == null) {
            return false;
        }
        return other.getOperatingSystemFamily() == null || other.getOperatingSystemFamily().equals(this.getOperatingSystemFamily());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCpuArchitecture() == null ? 0 : this.getCpuArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystemFamily() == null ? 0 : this.getOperatingSystemFamily().hashCode());
        return hashCode;
    }

    public RuntimePlatform clone() {
        try {
            return (RuntimePlatform)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuntimePlatformMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

