/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.HealthStatus;
import com.amazonaws.services.ecs.model.ManagedAgent;
import com.amazonaws.services.ecs.model.NetworkBinding;
import com.amazonaws.services.ecs.model.NetworkInterface;
import com.amazonaws.services.ecs.model.transform.ContainerMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Container
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerArn;
    private String taskArn;
    private String name;
    private String image;
    private String imageDigest;
    private String runtimeId;
    private String lastStatus;
    private Integer exitCode;
    private String reason;
    private SdkInternalList<NetworkBinding> networkBindings;
    private SdkInternalList<NetworkInterface> networkInterfaces;
    private String healthStatus;
    private SdkInternalList<ManagedAgent> managedAgents;
    private String cpu;
    private String memory;
    private String memoryReservation;
    private SdkInternalList<String> gpuIds;

    public void setContainerArn(String containerArn) {
        this.containerArn = containerArn;
    }

    public String getContainerArn() {
        return this.containerArn;
    }

    public Container withContainerArn(String containerArn) {
        this.setContainerArn(containerArn);
        return this;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public Container withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Container withName(String name) {
        this.setName(name);
        return this;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public Container withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setImageDigest(String imageDigest) {
        this.imageDigest = imageDigest;
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    public Container withImageDigest(String imageDigest) {
        this.setImageDigest(imageDigest);
        return this;
    }

    public void setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public Container withRuntimeId(String runtimeId) {
        this.setRuntimeId(runtimeId);
        return this;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public Container withLastStatus(String lastStatus) {
        this.setLastStatus(lastStatus);
        return this;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public Container withExitCode(Integer exitCode) {
        this.setExitCode(exitCode);
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public Container withReason(String reason) {
        this.setReason(reason);
        return this;
    }

    public List<NetworkBinding> getNetworkBindings() {
        if (this.networkBindings == null) {
            this.networkBindings = new SdkInternalList();
        }
        return this.networkBindings;
    }

    public void setNetworkBindings(Collection<NetworkBinding> networkBindings) {
        if (networkBindings == null) {
            this.networkBindings = null;
            return;
        }
        this.networkBindings = new SdkInternalList(networkBindings);
    }

    public Container withNetworkBindings(NetworkBinding ... networkBindings) {
        if (this.networkBindings == null) {
            this.setNetworkBindings((Collection<NetworkBinding>)new SdkInternalList(networkBindings.length));
        }
        for (NetworkBinding ele : networkBindings) {
            this.networkBindings.add((Object)ele);
        }
        return this;
    }

    public Container withNetworkBindings(Collection<NetworkBinding> networkBindings) {
        this.setNetworkBindings(networkBindings);
        return this;
    }

    public List<NetworkInterface> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new SdkInternalList();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new SdkInternalList(networkInterfaces);
    }

    public Container withNetworkInterfaces(NetworkInterface ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces((Collection<NetworkInterface>)new SdkInternalList(networkInterfaces.length));
        }
        for (NetworkInterface ele : networkInterfaces) {
            this.networkInterfaces.add((Object)ele);
        }
        return this;
    }

    public Container withNetworkInterfaces(Collection<NetworkInterface> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public Container withHealthStatus(String healthStatus) {
        this.setHealthStatus(healthStatus);
        return this;
    }

    public Container withHealthStatus(HealthStatus healthStatus) {
        this.healthStatus = healthStatus.toString();
        return this;
    }

    public List<ManagedAgent> getManagedAgents() {
        if (this.managedAgents == null) {
            this.managedAgents = new SdkInternalList();
        }
        return this.managedAgents;
    }

    public void setManagedAgents(Collection<ManagedAgent> managedAgents) {
        if (managedAgents == null) {
            this.managedAgents = null;
            return;
        }
        this.managedAgents = new SdkInternalList(managedAgents);
    }

    public Container withManagedAgents(ManagedAgent ... managedAgents) {
        if (this.managedAgents == null) {
            this.setManagedAgents((Collection<ManagedAgent>)new SdkInternalList(managedAgents.length));
        }
        for (ManagedAgent ele : managedAgents) {
            this.managedAgents.add((Object)ele);
        }
        return this;
    }

    public Container withManagedAgents(Collection<ManagedAgent> managedAgents) {
        this.setManagedAgents(managedAgents);
        return this;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getCpu() {
        return this.cpu;
    }

    public Container withCpu(String cpu) {
        this.setCpu(cpu);
        return this;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getMemory() {
        return this.memory;
    }

    public Container withMemory(String memory) {
        this.setMemory(memory);
        return this;
    }

    public void setMemoryReservation(String memoryReservation) {
        this.memoryReservation = memoryReservation;
    }

    public String getMemoryReservation() {
        return this.memoryReservation;
    }

    public Container withMemoryReservation(String memoryReservation) {
        this.setMemoryReservation(memoryReservation);
        return this;
    }

    public List<String> getGpuIds() {
        if (this.gpuIds == null) {
            this.gpuIds = new SdkInternalList();
        }
        return this.gpuIds;
    }

    public void setGpuIds(Collection<String> gpuIds) {
        if (gpuIds == null) {
            this.gpuIds = null;
            return;
        }
        this.gpuIds = new SdkInternalList(gpuIds);
    }

    public Container withGpuIds(String ... gpuIds) {
        if (this.gpuIds == null) {
            this.setGpuIds((Collection<String>)new SdkInternalList(gpuIds.length));
        }
        for (String ele : gpuIds) {
            this.gpuIds.add((Object)ele);
        }
        return this;
    }

    public Container withGpuIds(Collection<String> gpuIds) {
        this.setGpuIds(gpuIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerArn() != null) {
            sb.append("ContainerArn: ").append(this.getContainerArn()).append(",");
        }
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: ").append(this.getTaskArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getImageDigest() != null) {
            sb.append("ImageDigest: ").append(this.getImageDigest()).append(",");
        }
        if (this.getRuntimeId() != null) {
            sb.append("RuntimeId: ").append(this.getRuntimeId()).append(",");
        }
        if (this.getLastStatus() != null) {
            sb.append("LastStatus: ").append(this.getLastStatus()).append(",");
        }
        if (this.getExitCode() != null) {
            sb.append("ExitCode: ").append(this.getExitCode()).append(",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: ").append(this.getReason()).append(",");
        }
        if (this.getNetworkBindings() != null) {
            sb.append("NetworkBindings: ").append(this.getNetworkBindings()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getHealthStatus() != null) {
            sb.append("HealthStatus: ").append(this.getHealthStatus()).append(",");
        }
        if (this.getManagedAgents() != null) {
            sb.append("ManagedAgents: ").append(this.getManagedAgents()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getMemoryReservation() != null) {
            sb.append("MemoryReservation: ").append(this.getMemoryReservation()).append(",");
        }
        if (this.getGpuIds() != null) {
            sb.append("GpuIds: ").append(this.getGpuIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        if (other.getContainerArn() == null ^ this.getContainerArn() == null) {
            return false;
        }
        if (other.getContainerArn() != null && !other.getContainerArn().equals(this.getContainerArn())) {
            return false;
        }
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getImageDigest() == null ^ this.getImageDigest() == null) {
            return false;
        }
        if (other.getImageDigest() != null && !other.getImageDigest().equals(this.getImageDigest())) {
            return false;
        }
        if (other.getRuntimeId() == null ^ this.getRuntimeId() == null) {
            return false;
        }
        if (other.getRuntimeId() != null && !other.getRuntimeId().equals(this.getRuntimeId())) {
            return false;
        }
        if (other.getLastStatus() == null ^ this.getLastStatus() == null) {
            return false;
        }
        if (other.getLastStatus() != null && !other.getLastStatus().equals(this.getLastStatus())) {
            return false;
        }
        if (other.getExitCode() == null ^ this.getExitCode() == null) {
            return false;
        }
        if (other.getExitCode() != null && !other.getExitCode().equals(this.getExitCode())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        if (other.getReason() != null && !other.getReason().equals(this.getReason())) {
            return false;
        }
        if (other.getNetworkBindings() == null ^ this.getNetworkBindings() == null) {
            return false;
        }
        if (other.getNetworkBindings() != null && !other.getNetworkBindings().equals(this.getNetworkBindings())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getHealthStatus() == null ^ this.getHealthStatus() == null) {
            return false;
        }
        if (other.getHealthStatus() != null && !other.getHealthStatus().equals(this.getHealthStatus())) {
            return false;
        }
        if (other.getManagedAgents() == null ^ this.getManagedAgents() == null) {
            return false;
        }
        if (other.getManagedAgents() != null && !other.getManagedAgents().equals(this.getManagedAgents())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getMemoryReservation() == null ^ this.getMemoryReservation() == null) {
            return false;
        }
        if (other.getMemoryReservation() != null && !other.getMemoryReservation().equals(this.getMemoryReservation())) {
            return false;
        }
        if (other.getGpuIds() == null ^ this.getGpuIds() == null) {
            return false;
        }
        return other.getGpuIds() == null || other.getGpuIds().equals(this.getGpuIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerArn() == null ? 0 : this.getContainerArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getImageDigest() == null ? 0 : this.getImageDigest().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeId() == null ? 0 : this.getRuntimeId().hashCode());
        hashCode = 31 * hashCode + (this.getLastStatus() == null ? 0 : this.getLastStatus().hashCode());
        hashCode = 31 * hashCode + (this.getExitCode() == null ? 0 : this.getExitCode().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkBindings() == null ? 0 : this.getNetworkBindings().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getHealthStatus() == null ? 0 : this.getHealthStatus().hashCode());
        hashCode = 31 * hashCode + (this.getManagedAgents() == null ? 0 : this.getManagedAgents().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryReservation() == null ? 0 : this.getMemoryReservation().hashCode());
        hashCode = 31 * hashCode + (this.getGpuIds() == null ? 0 : this.getGpuIds().hashCode());
        return hashCode;
    }

    public Container clone() {
        try {
            return (Container)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

