/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.LogConfiguration;
import com.amazonaws.services.ecs.model.ServiceConnectService;
import com.amazonaws.services.ecs.model.transform.ServiceConnectConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ServiceConnectConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private String namespace;
    private SdkInternalList<ServiceConnectService> services;
    private LogConfiguration logConfiguration;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public ServiceConnectConfiguration withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ServiceConnectConfiguration withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public List<ServiceConnectService> getServices() {
        if (this.services == null) {
            this.services = new SdkInternalList();
        }
        return this.services;
    }

    public void setServices(Collection<ServiceConnectService> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        this.services = new SdkInternalList(services);
    }

    public ServiceConnectConfiguration withServices(ServiceConnectService ... services) {
        if (this.services == null) {
            this.setServices((Collection<ServiceConnectService>)new SdkInternalList(services.length));
        }
        for (ServiceConnectService ele : services) {
            this.services.add((Object)ele);
        }
        return this;
    }

    public ServiceConnectConfiguration withServices(Collection<ServiceConnectService> services) {
        this.setServices(services);
        return this;
    }

    public void setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public LogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public ServiceConnectConfiguration withLogConfiguration(LogConfiguration logConfiguration) {
        this.setLogConfiguration(logConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getServices() != null) {
            sb.append("Services: ").append(this.getServices()).append(",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: ").append(this.getLogConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectConfiguration)) {
            return false;
        }
        ServiceConnectConfiguration other = (ServiceConnectConfiguration)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        if (other.getServices() != null && !other.getServices().equals(this.getServices())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        return other.getLogConfiguration() == null || other.getLogConfiguration().equals(this.getLogConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        return hashCode;
    }

    public ServiceConnectConfiguration clone() {
        try {
            return (ServiceConnectConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceConnectConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

