/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.TaskField;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeTasksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> tasks;
    private SdkInternalList<String> include;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public DescribeTasksRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getTasks() {
        if (this.tasks == null) {
            this.tasks = new SdkInternalList();
        }
        return this.tasks;
    }

    public void setTasks(Collection<String> tasks) {
        if (tasks == null) {
            this.tasks = null;
            return;
        }
        this.tasks = new SdkInternalList(tasks);
    }

    public DescribeTasksRequest withTasks(String ... tasks) {
        if (this.tasks == null) {
            this.setTasks((Collection<String>)new SdkInternalList(tasks.length));
        }
        for (String ele : tasks) {
            this.tasks.add((Object)ele);
        }
        return this;
    }

    public DescribeTasksRequest withTasks(Collection<String> tasks) {
        this.setTasks(tasks);
        return this;
    }

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new SdkInternalList();
        }
        return this.include;
    }

    public void setInclude(Collection<String> include) {
        if (include == null) {
            this.include = null;
            return;
        }
        this.include = new SdkInternalList(include);
    }

    public DescribeTasksRequest withInclude(String ... include) {
        if (this.include == null) {
            this.setInclude((Collection<String>)new SdkInternalList(include.length));
        }
        for (String ele : include) {
            this.include.add((Object)ele);
        }
        return this;
    }

    public DescribeTasksRequest withInclude(Collection<String> include) {
        this.setInclude(include);
        return this;
    }

    public DescribeTasksRequest withInclude(TaskField ... include) {
        SdkInternalList includeCopy = new SdkInternalList(include.length);
        for (TaskField value : include) {
            includeCopy.add((Object)value.toString());
        }
        if (this.getInclude() == null) {
            this.setInclude((Collection<String>)includeCopy);
        } else {
            this.getInclude().addAll((Collection<String>)includeCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getTasks() != null) {
            sb.append("Tasks: ").append(this.getTasks()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTasksRequest)) {
            return false;
        }
        DescribeTasksRequest other = (DescribeTasksRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTasks() == null ^ this.getTasks() == null) {
            return false;
        }
        if (other.getTasks() != null && !other.getTasks().equals(this.getTasks())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTasks() == null ? 0 : this.getTasks().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public DescribeTasksRequest clone() {
        return (DescribeTasksRequest)super.clone();
    }
}

